<?php
require_once '../config/db.php';

echo "=== M-Pesa Callback System Status Check ===\n\n";

// Check logs directory
echo "1. Checking Logs Directory:\n";
$logsDir = '../logs';
if (file_exists($logsDir)) {
    echo "✓ Logs directory exists\n";
    
    // Check callback log
    $callbackLog = $logsDir . '/mpesa_callback.log';
    if (file_exists($callbackLog)) {
        echo "✓ Callback log exists\n";
        echo "Last 5 lines of callback log:\n";
        $lines = array_slice(file($callbackLog), -5);
        foreach ($lines as $line) {
            echo "  " . trim($line) . "\n";
        }
    } else {
        echo "✗ Callback log not found\n";
    }
    
    // Check error log
    $errorLog = $logsDir . '/mpesa_errors.log';
    if (file_exists($errorLog)) {
        echo "✓ Error log exists\n";
        echo "Last 5 lines of error log:\n";
        $lines = array_slice(file($errorLog), -5);
        foreach ($lines as $line) {
            echo "  " . trim($line) . "\n";
        }
    } else {
        echo "✗ Error log not found\n";
    }
} else {
    echo "✗ Logs directory not found\n";
}

// Check database
echo "\n2. Checking Database:\n";
try {
    // Get recent payments
    $stmt = $pdo->query("
        SELECT 
            id,
            checkout_request_id,
            status,
            mpesa_receipt,
            transaction_date,
            created_at,
            updated_at
        FROM credit_payments 
        ORDER BY created_at DESC 
        LIMIT 5
    ");
    
    $payments = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    if (count($payments) > 0) {
        echo "✓ Found " . count($payments) . " recent payments:\n";
        foreach ($payments as $payment) {
            echo "\nPayment ID: " . $payment['id'] . "\n";
            echo "Checkout Request ID: " . $payment['checkout_request_id'] . "\n";
            echo "Status: " . $payment['status'] . "\n";
            echo "M-Pesa Receipt: " . $payment['mpesa_receipt'] . "\n";
            echo "Transaction Date: " . $payment['transaction_date'] . "\n";
            echo "Created: " . $payment['created_at'] . "\n";
            echo "Updated: " . $payment['updated_at'] . "\n";
        }
    } else {
        echo "No recent payments found\n";
    }
} catch (PDOException $e) {
    echo "✗ Database error: " . $e->getMessage() . "\n";
} 